/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;

public class Runtime {
    private static Runtime currentRuntime = new Runtime();
    private String[] paths;

    public static Runtime getRuntime() {
        return currentRuntime;
    }

    private Runtime() {
    }

    private native void exitInternal(int var1);

    public void exit(int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkExit(n);
        }
        this.exitInternal(n);
    }

    public static void runFinalizersOnExit(boolean bl) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkExit(0);
            }
            catch (SecurityException securityException) {
                throw new SecurityException("runFinalizersOnExit");
            }
        }
        Runtime.runFinalizersOnExit0(bl);
    }

    private static native void runFinalizersOnExit0(boolean var0);

    private native Process execInternal(String[] var1, String[] var2) throws IOException;

    public Process exec(String string) throws IOException {
        return this.exec(string, null);
    }

    public Process exec(String string, String[] stringArray) throws IOException {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        n = stringTokenizer.countTokens();
        String[] stringArray2 = new String[n];
        stringTokenizer = new StringTokenizer(string);
        n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray2[n++] = stringTokenizer.nextToken();
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkExec(stringArray2[0]);
        }
        return this.execInternal(stringArray2, stringArray);
    }

    public Process exec(String[] stringArray) throws IOException {
        return this.exec(stringArray, null);
    }

    public Process exec(String[] stringArray, String[] stringArray2) throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkExec(stringArray[0]);
        }
        return this.execInternal(stringArray, stringArray2);
    }

    public native long freeMemory();

    public native long totalMemory();

    public native void gc();

    public native void runFinalization();

    public native void traceInstructions(boolean var1);

    public native void traceMethodCalls(boolean var1);

    private synchronized native String initializeLinkerInternal();

    private native String buildLibName(String var1, String var2);

    private native int loadFileInternal(String var1);

    private void initializeLinker() {
        String string = this.initializeLinkerInternal();
        char c = System.getProperty("path.separator").charAt(0);
        int n = string.length();
        int n2 = string.indexOf(c);
        int n3 = 0;
        while (n2 >= 0) {
            ++n3;
            n2 = string.indexOf(c, n2 + 1);
        }
        this.paths = new String[n3 + 1];
        n2 = 0;
        n3 = 0;
        int n4 = string.indexOf(c);
        while (n4 >= 0) {
            if (n4 - n2 > 0) {
                this.paths[n3++] = string.substring(n2, n4);
            } else if (n4 - n2 == 0) {
                this.paths[n3++] = ".";
            }
            n2 = n4 + 1;
            n4 = string.indexOf(c, n2);
        }
        this.paths[n3] = string.substring(n2, n);
    }

    public synchronized void load(String string) {
        int n;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkLink(string);
        }
        if ((n = this.loadFileInternal(string)) == -1) {
            throw new OutOfMemoryError();
        }
        if (n == 0) {
            throw new UnsatisfiedLinkError(string);
        }
    }

    public synchronized void loadLibrary(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkLink(string);
        }
        if (this.paths == null) {
            this.initializeLinker();
        }
        int n = 0;
        while (n < this.paths.length) {
            String string2 = this.buildLibName(this.paths[n], string);
            int n2 = this.loadFileInternal(string2);
            if (n2 == -1) {
                throw new OutOfMemoryError();
            }
            if (n2 == 1) {
                return;
            }
            ++n;
        }
        throw new UnsatisfiedLinkError("no " + string + " in shared library path");
    }

    public InputStream getLocalizedInputStream(InputStream inputStream) {
        return inputStream;
    }

    public OutputStream getLocalizedOutputStream(OutputStream outputStream) {
        return outputStream;
    }
}

